///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   FLASH.C - Flash Processing Module
// 
//
//   DESCRIPTION
//
//   Processing and control loop functions for Flash programming.
//
//
//
//   REVISION HISTORY
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <graph.h>
#include <conio.h>
#include <share.h>
#include <ctype.h>
#include <string.h>
#include "gentypes.h"
#include "gencons.h"
#include "labmon.h"
#include "monmisc.h"
#include "ztypes.h"
#include "monmisc.h"
#include "mess_io.h"
#include "display.h"
#include "util.h"

void wait(float);  
void clear_message_line(void);
void clear_command_line(void);   

//#define _DEBUG

#ifdef _DEBUG
  static KeyboardType  kb;
  static short  have_synch;
  static short ByteIn=0, Byte_1=0, i=0; 
  static unsigned char  InitBlock[15];
  static bytein=0, byte_1=0, byte_2=0, byte_3=0;
  static short WhichBlock=0;
  static short rec_cnt = 4, data_len=0;
  extern tZMSG   ZMsg;
  extern tMSGBUF ZMsgBuf;                       // zodiac msg processing buffer
  static unsigned short CurrentBlock=0;
  static int Ch=0;
//  static long temprate=9600;
  static char tempchar[1];
#endif

static char  MsgBuf[80];
static short Want_Exit=0;
static unsigned short InitCheckSum=0;
static unsigned short pause=0,step=1;
static short valid,NumBlocks=0,BlockSize=0;                                            

extern short FlashMode;
extern short gpscom, gpsnbit, gpssbit, tempnbit, tempsbit;
extern long  gpsbaud, temprate;         
extern char  gpsprty, tempprty; 
extern unsigned short gpsport, gpsirq;

extern unsigned char msgbuff[MAX_MSG_BUFFER];  /* Local Buffer defined in Labmon.c */
static FILE *RFB_FilePtr;
static char RFBFileName[35]="";

// function prototypes
void ChangeBaud(void);
int  OpenRFBFile(void);
void GetRFBInit(void);
void SendRFBBlock(unsigned short);

unsigned short GetSerialSynch(void);
unsigned short ProcSerialPort(void);

void ProcError(int ErrorLevel);
int  ProcKey(KeyboardType key);

#ifdef _DEBUG
void Debug(void);
#endif

void Send_RFB(void)
{
   #ifndef _DEBUG
     KeyboardType  kb;
//     short  have_synch;
//     long temprate = 9600;
//     char tempchar[1] = {'F'};
   #endif

   // initial global variables
   #ifdef _DEBUG
     kb.scan = 0;
     ByteIn=0; Byte_1=0; i=0; 
     bytein=0; byte_1=0; byte_2=0; byte_3=0;
     WhichBlock=0;
     rec_cnt = 4, data_len=0;
     CurrentBlock=0;
     Ch=0;
//     temprate = 9600;
//     tempchar[0] = 'F';
   #endif

//   flush_keys();  // flush keyboard
//   Want_Exit = 0;
//   have_synch = 0;
//   InitCheckSum=0;
//   pause=0;step=1;
//   valid=0;NumBlocks=0;BlockSize=0;                                            

   // set to high baud rate
//   temprate = gpsbaud;
//   gpsbaud  = 38400;
//   ChangeBaud();

//   clear_command_line();  
//   tempchar[0] = ask_char("MODE (F=FAST , S=SLOW) -> ", 'F', &valid);
//   clear_command_line();  
//   if(!valid) tempchar[0] = 'F';     
//   switch(toupper(tempchar[0])){
//     case 'F':
//       get_send_file();
//       Send_File();
//       Want_Exit = 1;
//       break;
//     case 'S':
//     default:
//       break;
//   } // end switch
   

   // open rfb file (_DEBUG - open dbg file also)
//   if(!Want_Exit) OpenRFBFile();
   
   // get init block of rfb file
//   if(!Want_Exit) GetRFBInit();
   

   // main loop 
//   while(!Want_Exit){       // get byte from file until eof
     
     // establish sync on serial data or process data
//     if(!have_synch){
//       have_synch = GetSerialSynch();
//     } // est synch
//     else{
//       have_synch = ProcSerialPort();
//     }
   
   switch ( *(((unsigned short *)(msgbuff))+5) ) { 
   	  case 0:
   	  case 1:
   	     if(FlashMode) {
            gpsbaud = temprate; gpsprty = tempprty;
            gpsnbit = tempnbit; gpssbit = tempsbit;
            ChangeBaud();
            FlashMode = 0;
         }
         break;
      case 7:             // send init block
         // set to high baud rate
         gpsbaud = 38400;
         gpsprty = 'N';
         gpsnbit = 8;
         gpssbit = 1;
         ChangeBaud(); 
         GetRFBInit();
         clear_message_line();
         break;
     
      case 8:             // resend init block
         fseek(RFB_FilePtr,0,SEEK_SET);  
         GetRFBInit();
         // clear_message_line();
         break;
      case 9:             // resend block
         SendRFBBlock(2);  
         break;
      case 4:             // send next block
         #ifdef _DEBUG
            Debug();
         #endif 
         SendRFBBlock(1); 
         // process any keyboard action
         if(kbhit()){
            kb = getkey(GETKEY);
            if(!ProcKey(kb)) {
               break;
            }
         } // end check keyboard 
         else {
            break;
         }
      default:            // complete or error
         fclose(RFB_FilePtr);
         // reset to 9600 baud rate
         if(*(((unsigned short *)msgbuff)+5) == 6) {
            gpsbaud = 9600; gpsprty = 'N';
            gpsnbit = 8; gpssbit = 1;
         }
         else {
            FlashMode = 0;
            gpsbaud = temprate; gpsprty = tempprty;
            gpsnbit = tempnbit; gpssbit = tempsbit;
         }
         ChangeBaud();
         break;
   } // end switch

} // end Send_RFB

int OpenRFBFile(void)
{
   clear_message_line();
   ask_str("ENTER FLASH FILE NAME -> ", RFBFileName, &valid);
   clear_message_line(); 
   if(!valid) return(1);     
   clear_message_line(); 
      
   if((RFB_FilePtr = _fsopen(RFBFileName, "rb", SH_DENYWR)) == NULL){
      clear_message_line();
      _outtext("FILE NOT FOUND\7");
      return(1);
   }
   else{ 
   	  clear_message_line();
   	  _outtext("TURN FLASH UNIT ON");
      return(0);
   }
   
} // end OpenRFBFile


//void OpenRFBFile(void)
//{
   // get rfb file
//   clear_command_line();
//   ask_str("ENTER RFB FILE NAME -> ", RFBFileName, &valid);
//   if(!valid){     
//     ProcError(1);
//     return;
//   }   

//   if((RFB_FilePtr = _fsopen(RFBFileName, "rb", SH_DENYWR)) == NULL){
//     ProcError(2);
//     return;
//   }

//   return;
   
//} // end OpenRFBFile

void ChangeBaud(void)
{
   if(OpenGPS(gpsport, gpsirq, gpsbaud, gpsprty, gpsnbit, gpssbit)){;
     ProcError(7);
   }
   return;
} // end ChangeBaud
 
void GetRFBInit(void)
{
  #ifndef _DEBUG
    short ByteIn=0, Byte_1=0, i=0; 
    unsigned char  InitBlock[15];
  #endif
  
  while(1){ // get synch on rfb file
    if( !((Byte_1==0xFF) && (ByteIn==0x99)) ){
      Byte_1 = ByteIn;
      if( (ByteIn=fgetc(RFB_FilePtr)) == EOF ){     // get byte from file until eof
        ProcError(3);
        return;
      }
      continue;
    }
    else{
      break;
    }  
  } // end while - synch      
  InitBlock[0] = 0xFF;
  InitBlock[1] = 0x99;
  for( i=2; i<12; i++){
    if( (ByteIn=fgetc(RFB_FilePtr)) == EOF ){     // get byte from file until eof
      ProcError(3);
      return;
    }
    // put byte in local InitBlock update checksum
    InitBlock[i] =  (ByteIn&0xFF);
  }
  // have init block so if good checksum then get data and send to receiver
//  InitCheckSum = InitBlock[0] + InitBlock[1]    + InitBlock[2] + InitBlock[3] +
//                 InitBlock[4] + InitBlock[5]    + InitBlock[6] + InitBlock[7] +
//                 InitBlock[8] + InitBlock[9]<<8 + InitBlock[10];
//  if(InitCheckSum != 0){
//    ProcError(4);
//    return(0);
//  }
  for( i=0; i<12; i++){
    // send init block to receiver
    send_byte((BYTE)InitBlock[i]);                          
  }
  NumBlocks = (InitBlock[4]<<8)|(InitBlock[5]&0xFF);
  BlockSize = (InitBlock[6]<<8)|(InitBlock[7]&0xFF);
  cprintf("\a"); 
  clear_command_line(); 
  _outtext("INIT BLOCK SENT"); 
  wait(0.8f);
  return;
} // end GetRFBInit


unsigned short GetSerialSynch(void)
{
  #ifndef _DEBUG
    static bytein=0, byte_1=0, byte_2=0, byte_3=0;
  #endif
    
  // get a byte from the receiver port
  bytein = get_byte();

  // if bytein is -1 return
  if(bytein == -1){
    return(0);
  }

  if((bytein == 0x04) && (byte_1 == 0x9C) && (byte_2 == 0x81) && (byte_3 == 0xFF)){
    msgbuff[0] = (unsigned char)byte_3;
	msgbuff[1] = (unsigned char)byte_2;
	msgbuff[2] = (unsigned char)byte_1;
	msgbuff[3] = (unsigned char)bytein;
	return(1);
  } else {
    byte_3 = byte_2;
    byte_2 = byte_1;
    byte_1 = bytein;
    return(0);
  }
} // end GetSerialSynch

unsigned short ProcSerialPort(void)
{
  #ifndef _DEBUG
    short bytein=0,i=0,WhichBlock=0;
    static short rec_cnt = 4, data_len=0;
    extern tZMSG   ZMsg;
    extern tMSGBUF ZMsgBuf;                       // zodiac msg processing buffer
  #endif
  
  // get a byte from the receiver port
  bytein = get_byte();

  // put data in buffer
  if(bytein != -1){
    msgbuff[rec_cnt++] = (BYTE) bytein;  
  }
       
  // get message length and number of data bytes
  if(rec_cnt == 6){     
     i = (msgbuff[5]<<8)|(msgbuff[4]&0xFF);
     data_len  = 2 * i + ((i>0)?12:10);  
  }

  // check for complete message
  if(rec_cnt == data_len){
  
    // message ready to process
    if(get_cs(msgbuff,10)){
       // Bad header Checksum
       cprintf("\a"); 
       clear_command_line(); 
       _outtext("HEADER CHECKSUM ERROR"); 
    }
    else if(data_len>12 && get_cs(msgbuff+10,data_len-10)){
       // Bad data Checksum
       cprintf("\a");
       clear_command_line(); 
       _outtext("DATA CHECKSUM ERROR");         
    }
    else{
       // process zodiac binary protocol
       memcpy(&ZMsgBuf, msgbuff, rec_cnt);
       DecZMsg(&ZMsgBuf, ZMsg);
       WhichBlock =  (msgbuff[11]<<8) | (msgbuff[10]&0xFF);
       switch(WhichBlock){ //ZMsg.Msg1180.StatusNumber){
         case 4:
            SendRFBBlock(1); // send next block
            break;
         case 5: 
            SendRFBBlock(2); // send same block
            break;
         case 6: 
            Want_Exit  = 1;  // upload complete lets exit
            break;
         default:
            SendRFBBlock(0);
            break;
       } // end switch
    } // end if elseif else
    rec_cnt   = 4;
    data_len  = 10;
    return(0);
  } // rec_cnt = data_len
  return(1);
} // end ProcSerialPort

void SendRFBBlock(unsigned short WhichBlock)
{
   static short BlockA[2000]={0};

   #ifndef _DEBUG
     static unsigned short CurrentBlock=0;
     short ByteIn=0, i=0;
   #endif
   
   switch(WhichBlock){
     case 0: // reset CurrentBlock when done or error!
       CurrentBlock = 0;
       return;
     case 1: // send next block
       CurrentBlock++;
       break;
     case 2: // send last block so rewind to begining of last block 
//       fseek(RFB_FilePtr,-(BlockSize*2+10),SEEK_SET); 
       printf("\7");
       break;
     default: // no valid block
       return;
   }
   clear_command_line();
   sprintf(MsgBuf,"SENDING BLOCK:  %hu of %hu BLOCKS!\7",CurrentBlock,NumBlocks);
   // output the data items   
   ShowText(MsgBuf, CMDR-1, CMDC);  
//   wait(.5f);
   for(i=0; i<(BlockSize*2)+10; i++){  // +10 is for header and block checksum bytes
     
     if(WhichBlock == 2)
        ByteIn = BlockA[i];
       
           
     if(WhichBlock == 1) {
        if( (ByteIn=fgetc(RFB_FilePtr)) == EOF ){     // get byte from file until eof
           ProcError(3);
           return;
        }
        BlockA[i] = ByteIn;
     }
     
     // send byte
     send_byte((BYTE)ByteIn); 
     
//     if(i<30) {
//        if(WhichBlock == 1)
//           BlockA[i] = (unsigned char)ByteIn;
//        else if(WhichBlock == 2)
//           BlockB[i] = (unsigned char)ByteIn;
//     }                         
   }
   
//   BlockA[30] = '\0';
//   BlockB[30] = '\0';
//   if(WhichBlock == 2) {
//      ShowText(BlockA,37,20);
//      ShowText(BlockB,38,20);
//   }
   //cprintf("\a"); 
//   clear_command_line(); 
//   sprintf(MsgBuf,"BLOCK %hu SENT",CurrentBlock);
//   _outtext(MsgBuf); 

} // end SendRFBBlock

void ProcError(int ErrorLevel)
{
   switch(ErrorLevel){
     case 1:
     	sprintf(MsgBuf,"%s IS NOT A VALID ENTRY!\7",RFBFileName);
     	break;
     case 2:
     	sprintf(MsgBuf,"COULDN'T OPEN: %s!\7",RFBFileName);
     	break;
     case 3:
     	sprintf(MsgBuf,"EOF FOUND!\7");
     	break;
     case 4:
     	sprintf(MsgBuf,"INIT BLOCK CHECKSUM ERROR: %04hX\7",InitCheckSum);
     	break;
     case 5:
     	sprintf(MsgBuf,"USER TERMINATED SEND!\7");
     	break;
     case 6:
     	sprintf(MsgBuf,"COULDN'T OPEN: %s!\7","flash.dgb");
     	break;
     case 7:
     	sprintf(MsgBuf,"COULDN'T CHANGE BAUD RATE!\7");
     	break;
     default:  // no error
     	break;
   } // end switch
   // output the data items   
   clear_command_line();                                                                                               
   ShowText(MsgBuf, CMDR-1, CMDC);  
   wait(.5f);
   Want_Exit = 1;  // lets go home
   return;
   
} // end ProcError

int ProcKey(KeyboardType key)
{

  switch(key.scan){
    case 1:         // ESC - exit
      ProcError(5);
      return 1;
    case 46:        // 'C' - clear screen
      clear_screen();
      break;     
    
    #ifdef _DEBUG
    case 25:        // 'P' - toggle pause  
      pause ^= 1;
      break; 
    case 31:        // 'S' - single step  
      step ^= 1;
      break;
    #endif       
    
    default:
      break;
  } // end switch 
  return 0;
} // end ProcKey

#ifdef _DEBUG
void Debug(void)
{ 
  clear_message_line();
  sprintf(MsgBuf,"NB=%hu  BS=%hu  WB=%hu  CB=%hu  Sta=%hu  Rec=%hu  Byte=%02hX  DL=%hu  Ch=%c",
          NumBlocks,BlockSize,WhichBlock,CurrentBlock,ZMsg.Msg1180.StatusNumber,rec_cnt,
          bytein,data_len,Ch);
  _outtext(MsgBuf);
  while(pause){
    // check keyboard
    if(kbhit()){
      kb = getkey(GETKEY);
      ProcKey(kb);
      if(Want_Exit) break;
    } // end check keyboard
  } // end while pause
  if(step){
    Ch=_getch();     // halts until char entered
    switch(Ch){
      case 'S':
      case 's':
        step ^= 1;
        break;
      case 'P':
      case 'p':
        pause ^= 1;
        break;
      case 27: // escape
        ProcError(5);
        break;
      default:
        break;
    } // end switch          
  } // end if step
} // end Debug
#endif
   